/*
 * Decompiled with CFR 0.152.
 */
package macierz;

public class Macierz {
    private int rows;
    private int columns;
    private float[][] elements;

    public void setelement(int r, int c, float value) {
        this.elements[r - 1][c - 1] = value;
    }

    public float getelement(int r, int c) {
        return this.elements[r - 1][c - 1];
    }

    float minor(int r, int c) {
        if (r == 1 && c == 1) {
            return this.getelement(2, 2);
        }
        if (r == 1 && c == 2) {
            return this.getelement(2, 1);
        }
        if (r == 2 && c == 1) {
            return this.getelement(1, 2);
        }
        if (r == 2 && c == 2) {
            return this.getelement(1, 1);
        }
        return 0.0f;
    }

    Macierz macdop() {
        Macierz f = new Macierz(this.columns, this.rows);
        f.setelement(1, 1, this.minor(1, 1));
        f.setelement(1, 2, -this.minor(1, 2));
        f.setelement(2, 1, -this.minor(2, 1));
        f.setelement(2, 2, this.minor(2, 2));
        return f;
    }

    public Macierz add(Macierz a) {
        for (int i = 1; i <= this.rows; ++i) {
            for (int j = 1; j <= this.columns; ++j) {
                this.setelement(i, j, a.getelement(i, j) + this.getelement(i, j));
            }
        }
        return this;
    }

    public Macierz minus(Macierz a) {
        for (int i = 1; i <= this.rows; ++i) {
            for (int j = 1; j <= this.columns; ++j) {
                this.setelement(i, j, this.getelement(i, j) - a.getelement(i, j));
            }
        }
        return this;
    }

    public Macierz inverse() {
        Macierz f = new Macierz(this.columns, this.rows);
        f = this.macdop().trans().multiply(1.0f / this.det());
        return f;
    }

    public Macierz multiply(Macierz b) {
        Macierz c = new Macierz(this.rows, b.columns);
        for (int i = 1; i <= c.rows; ++i) {
            for (int k = 1; k <= c.columns; ++k) {
                float x = 0.0f;
                for (int j = 1; j <= this.rows; ++j) {
                    x += this.getelement(i, j) * b.getelement(j, k);
                }
                c.setelement(i, k, x);
            }
        }
        return c;
    }

    Macierz multiply(float a) {
        for (int i = 1; i <= this.rows; ++i) {
            for (int j = 1; j <= this.columns; ++j) {
                this.setelement(i, j, this.getelement(i, j) * a);
            }
        }
        return this;
    }

    Macierz trans() {
        Macierz f = new Macierz(this.columns, this.rows);
        for (int i = 1; i <= this.rows; ++i) {
            for (int j = 1; j <= this.columns; ++j) {
                f.setelement(j, i, this.getelement(i, j));
            }
        }
        return f;
    }

    float det() {
        float wynik = this.getelement(1, 1) * this.getelement(2, 2) - this.getelement(1, 2) * this.getelement(2, 1);
        return wynik;
    }

    void print() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                System.out.println("element (w" + (i + 1) + ",k" + (j + 1) + ")=" + this.elements[i][j]);
            }
        }
    }

    public Macierz(int r, int c) {
        this.rows = r;
        this.columns = c;
        this.elements = new float[this.rows][this.columns];
    }

    public Macierz() {
        this.rows = 2;
        this.columns = 2;
        this.elements = new float[this.rows][this.columns];
    }
}

